﻿

namespace ProAzure.MachineInfo.Service
{
    using System;
    using System.Diagnostics;
    using System.Security.Cryptography;
    using System.Text;
    using System.ServiceModel;

    [ServiceBehavior(AddressFilterMode = AddressFilterMode.Any)]
   public class ACSExample : IACSExample
    {
        const string key = "PROAZURE";
 
        #region IACSExample Members

        public string GetMachineName()
        {
            return Environment.MachineName;
        }

        public string GetUserDomainName()
        {
            return Environment.UserDomainName;
        }

        public string GetOSVersion()
        {
            return Environment.OSVersion.VersionString;
        }

      

        public byte[] EncodeString(string data)
        {
            // Initialize the keyed hash object.
            HMACSHA256 myhmacsha256 = new HMACSHA256(Encoding.UTF8.GetBytes(key));
            // Compute the hash of the input data.
            return myhmacsha256.ComputeHash(Encoding.UTF8.GetBytes(data));

        } // end EncodeFile


        #endregion
    }
}
